StringVal="1e-4"
StringTask="RTE"
#"RTE CoLA SST2 MRPC STSB QQP QNLI MNLI"
model_name="google/electra-base-discriminator"
seeds="1 2 3 4 5"
for task in $StringTask; do
	for seed in $seeds; do
		for val in $StringVal; do 
		
			echo ${val}
			OutDir="results/finetune/${model_name}/${task}/lr-"
			OutDir+="${val}"
			OutDir+="-seed-${seed}"
			mkdir -p "$OutDir"
			echo ${OutDir}
			CUDA_VISIBLE_DEVICES=0 PYTHONPATH=$PYTHONPATH:./src python ./src/finetune/run_glue.py \
			--task_name ${task} \
			--model_name_or_path ${model_name}\
			--do_train \
			--do_eval \
			--do_predict \
			--learning_rate $val \
			--warmup_ratio 0.1 \
			--num_train_epochs 3 \
			--max_seq_length 128 \
			--output_dir $OutDir \
			--per_device_eval_batch_size=4 \
			--per_device_train_batch_size=4 \
			--gradient_accumulation_steps 8 \
			--overwrite_output \
			--overwrite_cache \
			--evaluation_strategy epoch \
			--seed ${seed} \
			--save_total_limit 1 \
			--save_steps 10000 |& tee "results/finetune/${model_name}/${task}/${task}_lr${val}_seed${seed}.txt" -i
			#--eval_steps 12 \
			#--logging_steps 12 \
			#--config_name "bert-base-cased" \
			#--tokenizer_name "bert-base-cased" \
			#--evaluate_during_training
			#unc-nlp/
		done
	done
done
